function new_X = remove_rep(Dif,X)

% new_X = remove_rep(Dif,X)
%
% Input Variables
%   Dif - The difference between two cell voltages
%   X - Intersection

% Output Variables
%   New_X- Removed repetative intersections
%
% Description
%   reomves repeated intersections between two cell voltages.

% Created
%   8/23/2006, Mohamed A Mneimneh, Marquette University
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
%
% Modified

new_X = 1;
temp_count = 1;
count = 1;
for i = 1:length(X)-1
   if ( X(i+1) ~= (X(i) + 1) && temp_count == 1 )
       new_X(count) = X(i);
       count = count + 1;
   elseif X(i+1) == (X(i) + 1) && i < length(X)-1
       temp(temp_count) = X(i);
       temp_count = temp_count + 1;
   elseif (temp_count > 1 )
       temp_X = find(Dif == max(Dif(temp)));
       new_X(count) = temp_X(1);
       count = count + 1;
       temp_count = 1;
       temp = 0;
   else
       new_X = 1;
   end
end